

# to echo output, use 'source("main.R", echo=TRUE)'

# clear workspace
rm(list=ls())

# load libraries
library("ggplot2")
library("reshape2")

# source and generate data
source("generate.R")

# http://docs.ggplot2.org/0.9.3.1/geom_errorbar.html

# https://mandymejia.wordpress.com/2013/11/13/10-reasons-to-switch-to-ggplot-7/

for (i in 3:12 ) {
  
  M <- aggregate(scale[,i] ~ Time, scale, function(x) c(M = mean(x)), simplify=TRUE)
  SE <- aggregate(scale[,i] ~ Time, scale, function(x) c(SE = sd(x)/sqrt(length(x))), simplify=TRUE)

  names(M) <- c("Time", "Mean")
  names(SE) <- c("Time", "SE")
  
  p <- ggplot(M, aes(x=Time, y=Mean, color=Time)) # just initializes
  p <- p + geom_bar(stat="identity", width=.5, color=M$Time) + #, fill="darkgreen", colour="darkgreen") + 
    geom_errorbar(aes(ymin=M$Mean-SE$SE, ymax=M$Mean+SE$SE), width=.3) # + #, fill="red", colour="red")
  
  filename <- paste("SUS", i, ".pdf", sep="")
  ggsave(file=filename)
  
}


#p0 <- ggplot(scale, aes(x = SUS1, y = SUS2, color = Time)) # just initializes
#p0 <- p0 + geom_point() + 
#  #geom_smooth() + 
#  facet_wrap(~ ID) + 
#  geom_line(aes(group = Time)) + 
#  theme(strip.background = element_blank(),
#        strip.text.x = element_blank())

for (i in 1:3) {
  
  T <- subset(scale, Time==i)
  p1 <- ggplot(T, aes(x=SUS5, y=SUS9, color=Time))
  p1 <- p1 + 
           geom_point() +
           #stat_density2d(aes(fill = ..level..), geom="polygon") +
           #geom_boxplot(aes(fill = factor(SUS5))) #+
           #geom_smooth() #+
           stat_density2d(geom="tile", aes(fill = ..density..), contour = FALSE) +
           geom_point() + 
           geom_density2d()
  filename <- paste("SUSvSUS", i, ".pdf", sep="")
  ggsave(file=filename)
  
}


M1 <- aggregate(scale[,8] ~ Time, scale, function(x) c(M = mean(x)), simplify=TRUE)
SE1 <- aggregate(scale[,8] ~ Time, scale, function(x) c(SE = sd(x)/sqrt(length(x))), simplify=TRUE)

names(M1) <- c("Time", "Mean")
names(SE1) <- c("Time", "SE")

M2 <- aggregate(scale[,4] ~ Time, scale, function(x) c(M = mean(x)), simplify=TRUE)
SE2 <- aggregate(scale[,4] ~ Time, scale, function(x) c(SE = sd(x)/sqrt(length(x))), simplify=TRUE)

names(M2) <- c("Time", "Mean")
names(SE2) <- c("Time", "SE")

diffM <- M1-M2
diffSE <- SE1-SE2

diffM$Time = c(1,2,3)
diffSE$Time = c(1,2,3)

p <- ggplot(diffM, aes(x=Time, y=Mean, color=Time)) # just initializes
p <- p + geom_bar(stat="identity", width=.5) + #, fill="darkgreen", colour="darkgreen") + 
  geom_errorbar(aes(ymin=diffM$Mean-diffSE$SE, ymax=diffM$Mean+diffSE$SE), width=.3) #, fill="red", colour="red")


# convert scores
# For positively-worded items (1, 3, 5, 7 and 9), the score contribution is the scale
# position minus 1. For negatively-worded items (2, 4, 6, 8 and 10), it is 5 minus the
# scale position. To get the overall SUS score, multiply the sum of the item score
# contributions by 2.5. Thus, SUS scores range from 0 to 100 in 2.5-point increments.
## 1. I think that I would like to use this system frequently.
## 2. I found the system unnecessarily complex.
## 3. I thought the system was easy to use.
## 4. I think that I would need the support of a technical person to be able to use this
## system.
## 5. I found the various functions in this system were well integrated.
## 6. I thought there was too much inconsistency in this system.
## 7. I would imagine that most people would learn to use this system very quickly.
## 8. I found the system very cumbersome to use.
## 9. I felt very confident using the system.
## 10. I needed to learn a lot of things before I could get going with this system.
SUS_mean <- {}
SUS_sd <- {}
SUS_sums <- {}
for (t in 1:3) {
  SUS_contributions={}
  T <- subset(scale, Time==t)
  for (i in 3:12) {
    i%%2
    if (i%%2==0) {
      SUS_contributions=cbind(SUS_contributions,5-T[,i])
    } else {
      SUS_contributions=cbind(SUS_contributions,T[,i]-1)
    }
  }
  SUS_contributions[SUS_contributions==-1]=0
  sum_C <- rowSums(SUS_contributions, na.rm=F, dims=1) * 2.5
  SUS_sums <- rbind(SUS_sums,cbind(rep(c(t),length(sum_C)),sum_C))
  SUS_mean <- rbind(SUS_mean,mean(sum_C))
  SUS_sd <- rbind(SUS_sd,sd(sum_C))
}

SUS <- data.frame(c(1,2,3),cbind(SUS_mean,SUS_sd))
names(SUS) <- c("Time","Mean","SD")

SUS_sums <- data.frame(SUS_sums)
names(SUS_sums) <- c("Time","Score")

p <- ggplot(SUS, aes(x=Time, y=Mean, fill=as.factor(Time)))
p <- p + xlim(0.0, 4.0) + 
  geom_bar(stat="identity", width=.5) + # aes(fill = SUS$Time)) +  
  geom_errorbar(aes(ymin=Mean-SD, ymax=Mean+SD), width=.3) + # + #, fill="red", colour="red") +
  theme_minimal() +
  scale_x_continuous(breaks=c(1.0,2.0,3.0)) +
  scale_fill_grey(name="month") +
  xlab("Time (month)")
  # TODO: remove ticks on x-axis

filename <- paste("SUS_scores.png", sep="")
ggsave(file=filename)
filename <- paste("SUS_scores.pdf", sep="")
ggsave(file=filename)


p <- ggplot(SUS_sums, aes(x=Time, y=Score))
p <- p + xlim(0.0, 4.0) + 
  geom_boxplot(aes(fill=as.factor(Time))) +  
  theme_minimal() +
  scale_x_continuous(breaks=c(1.0,2.0,3.0)) +
  scale_fill_grey(name="month") +
  xlab("Time (month)")
# TODO: remove ticks on x-axis

filename <- paste("SUS_scores_boxplots.png", sep="")
ggsave(file=filename)
filename <- paste("SUS_scores_boxplots.pdf", sep="")
ggsave(file=filename)


# create histograms of SUS scores over a three-month period
bin_width <- 5
p <- ggplot(SUS_sums, aes(x=Score)) + 
  #geom_histogram(data=subset(SUS_sums, Time=='1'), aes(y = ..density..), binwidth=bin_width, fill = "light gray", alpha = 0.5) + 
  #geom_histogram(data=subset(SUS_sums, Time=='2'), aes(y = ..density..), binwidth=bin_width, fill = "gray", alpha = 0.5) +
  #geom_histogram(data=subset(SUS_sums, Time=='3'), aes(y = ..density..), binwidth=bin_width, fill = "dark gray", alpha = 0.5) 
  geom_histogram(data=SUS_sums, aes(y = ..density.., group=Time), binwidth=bin_width, alpha = 0.5) 


ggsave("SUS_scores_histograms_overlayed.png")
ggsave("SUS_scores_histograms_overlayed.pdf")

p <- p + geom_density(data=SUS_sums, aes(y = ..density.., group=Time), alpha = 0.5)
  #geom_density(data=subset(SUS_sums, Time=='1'), aes(y = ..density..), fill = "light gray", alpha = 0.5) + 
  #geom_density(data=subset(SUS_sums, Time=='2'), aes(y = ..density..), fill = "gray", alpha = 0.5) + 
  #geom_density(data=subset(SUS_sums, Time=='3'), aes(y = ..density..), fill = "dark gray", alpha = 0.5)

ggsave("SUS_scores_histograms_overlayed_with_density.png")
ggsave("SUS_scores_histograms_overlayed_with_density.pdf")

p <-  p + scale_fill_grey(name="time") +
  scale_color_grey() +
  theme_bw() +
  scale_y_continuous(breaks=c(0.0,0.05,0.1)) +
  facet_grid(Time ~ .) + 
  geom_rug(sides="b")

ggsave("SUS_scores_histograms_facetted_with_density.png")
ggsave("SUS_scores_histograms_facetted_with_density.pdf")

#p <- ggplot(SUS_sums, aes(x=Score)) + 
#  geom_density(alpha = 0.2, fill=SUS_sums$Time)

# create density plots
p <- ggplot(SUS_sums, aes(x=Score)) + 
  geom_density(data=subset(SUS_sums, Time=='1'), aes(y = ..density..), fill = "red", alpha = 0.2) + 
  geom_density(data=subset(SUS_sums, Time=='2'), aes(y = ..density..), fill = "blue", alpha = 0.2) + 
  geom_density(data=subset(SUS_sums, Time=='3'), aes(y = ..density..), fill = "green", alpha = 0.2) 

# histogram with density line overlaid
p <- ggplot(SUS_sums, aes(x=Score)) + 
  geom_histogram(aes(y = ..density..), color="black", fill=NA) +
  geom_density(color="blue") 


## add the SUS score to scale dataframe
SUS_scores <- {}
for (j in 1:nrow(scale)) {
  SUS_contributions <- {}
  for (i in 3:12) {
    i%%2
    if (i%%2==0) {
      SUS_contributions=cbind(SUS_contributions,5-scale[j,i])
    } else {
      SUS_contributions=cbind(SUS_contributions,scale[j,i]-1)
    }
  }
  SUS_contributions[SUS_contributions<0]=0
  SUS_contributions[SUS_contributions>5]=5
  SUS_contributions
  SUS_score <- rowSums(SUS_contributions, na.rm=F, dims=1) * 2.5
  SUS_score
  SUS_scores <- rbind(SUS_scores, SUS_score)
}
scale <- cbind(scale,SUS_scores)



